(function($) {

/**
 * jQuery debugging helper.
 *
 * Invented for Dreditor.
 *
 * @usage
 *   $.debug(var [, name]);
 *   $variable.debug( [name] );
 */
jQuery.extend({
  debug: function () {
    // Setup debug storage in global window. We want to look into it.
    window.debug = window.debug || [];

    args = jQuery.makeArray(arguments);
    // Determine data source; this is an object for $variable.debug().
    // Also determine the identifier to store data with.
    if (typeof this == 'object') {
      var name = (args.length ? args[0] : window.debug.length);
      var data = this;
    }
    else {
      var name = (args.length > 1 ? args.pop() : window.debug.length);
      var data = args[0];
    }
    // Store data.
    window.debug[name] = data;
    // Dump data into Firebug console.
    if (typeof console != 'undefined') {
      console.log(name, data);
    }
    return this;
  }
});
// @todo Is this the right way?
jQuery.fn.debug = jQuery.debug;

})(jQuery);
;
(function ($) {
  Drupal.behaviors.fitvids = {
    attach: function (context, settings) {
      try
      {
        // Check that fitvids exists
        if (typeof $.fn.fitVids !== 'undefined') {
        
          // Check that the settings object exists
          if (typeof settings.fitvids !== 'undefined') {
            
            // Default settings values
            var selectors = ['body'];
            var simplifymarkup = true;
            var custom_domains = null;
            
            // Get settings for this behaviour
            if (typeof settings.fitvids.selectors !== 'undefined') {
              selectors = settings.fitvids.selectors;
            }
            if (typeof settings.fitvids.simplifymarkup !== 'undefined') {
              simplifymarkup = settings.fitvids.simplifymarkup;
            }
            if (settings.fitvids.custom_domains.length > 0) {
              custom_domains = settings.fitvids.custom_domains;
            }
                
            // Remove media wrappers
            if (simplifymarkup) {
              if ($(".media-youtube-outer-wrapper").length) {
                $(".media-youtube-outer-wrapper").removeAttr("style");
                $(".media-youtube-preview-wrapper").removeAttr("style");
                $(".media-youtube-outer-wrapper").removeClass("media-youtube-outer-wrapper");
                $(".media-youtube-preview-wrapper").removeClass("media-youtube-preview-wrapper");
              }
              if ($(".media-vimeo-outer-wrapper").length) {
                $(".media-vimeo-outer-wrapper").removeAttr("style");
                $(".media-vimeo-preview-wrapper").removeAttr("style");
                $(".media-vimeo-outer-wrapper").removeClass("media-vimeo-outer-wrapper");
                $(".media-vimeo-preview-wrapper").removeClass("media-vimeo-preview-wrapper");
              }
            }
            
            // Fitvids!
            for (var x = 0; x < selectors.length; x ++) {
              $(selectors[x]).fitVids({customSelector: custom_domains});
            }
          }
        }
      }
      catch (e) {
        // catch any fitvids errors
        window.console && console.warn('Fitvids stopped with the following exception');
        window.console && console.error(e);
      }
    }
  };
}(jQuery));
;
(function ($) {
/**
 * Media Colorbox behavior.
 */
Drupal.behaviors.initMediaColorbox = {
  attach: function (context, settings) {
    if (!$.isFunction($.colorbox)) {
      console.log('You must install the Colorbox library.');
      return;
    }
    var enableAudioPlaylist = false;

    $('a.media-colorbox', context).once('init-media-colorbox', function() {

      // Merge Colorbox settings with Media Colorbox settings from data attributes.
      var options = jQuery.extend({}, settings.colorbox);
      var mediaColorboxSettings = {};
      if($(this).data('mediaColorboxFixedWidth') > 0) {
        mediaColorboxSettings = {width: $(this).data('mediaColorboxFixedWidth')};
        jQuery.extend(options, mediaColorboxSettings);
      }
      if($(this).data('mediaColorboxFixedHeight') > 0){
        mediaColorboxSettings = {height: $(this).data('mediaColorboxFixedHeight')};
        jQuery.extend(options, mediaColorboxSettings);
      }

      // Set up the callback and listener to go to to next slide
      $(this).colorbox(options);
      if($(this).data('mediaColorboxAudioPlaylist')){
        enableAudioPlaylist = true;
      }
    });

    // Set up the callback and listener to go to to next slide
    $(document).bind('cbox_complete', function() {
      if(enableAudioPlaylist) {
        $("audio").bind("ended", function(event) {
          setTimeout($.colorbox.next, 100);
        });
      }
      $("#cboxLoadedContent img").bind("click", function (event) {
        setTimeout($.colorbox.next, 0);
      });
      $("#cboxLoadedContent img").css('cursor', 'pointer');
    });
  }
};
})(jQuery);
;
