Real-time SEo for Drupal
---------------------------
Improve your Drupal SEO: Write better content and have a fully optimized Drupal content using Realtime SEO for Drupal module.

This module is written from the ground up by [GoalGorilla](http://www.goalgorilla.com) to improve your site's SEO on *all* needed aspects. The [Real-time SEO for Drupal module](http://drupal.org/project/yoast_seo/) is heavily dependending on the [Yoast](http://www.yoast.com) library and [Metatag](http://drupal.org/project/metatag) module . Together they go the extra mile to take care of a lot technical optimization, more on that below, but it first and foremost helps you write better content. Realtime SEO forces you to choose a focus keyword when you're writing your articles, and then makes sure you use that focus keyword everywhere.



Features
------------------------------------------------------------------------------
This module checks simple things you're bound to forget. It checks, for instance, whether your posts are long enough, if you've written a meta description and if that meta description contains your focus keyword, if you've used any subheadings within your post, etc. etc.

This real-time page analysis makes sure that your content is the type of content search engines will love!



Installation & configuration
------------------------------------------------------------------------------
Step by step guide on how to install and use the Yoast SEO module:

1. Download the module from http://drupal.org/project/yoast_seo or download with drush (drush dl yoast_seo).
2. Make sure to install and enable the module.
3. The metatag and yoast_seo fields will be enabled by default for your content types.
4. Make sure your user account has the "Use Yoast SEO" permission as well as the appropriate permissions for Metatag and Path.
5. Set a focus keyword, page title and description when editing a piece of content.
6. Start writing your content and get real-time feedback on it's search engine performance with page analysis.



Credits / Contact
------------------------------------------------------------------------------
First of all we want to give credit to the Metatag team! We decided to make this module a dependency for the Realtime SEO for Drupal module and not rebuild all of their excellent work.

Secondly we want to thank the Yoast team for giving us the opportunity to develop a great Drupal module in combination with their real-time page analysis solution.

Please use the Drupal issue lists to report bugs or discuss ideas on improving this module.



References
------------------------------------------------------------------------------
Realtime SEO for Drupal module
* [Real-time SEO for Drupal](http://drupal.org/project/yoast_seo)

Realtime SEO for Drupal module dependencies:
* [Metatag](http://drupal.org/project/metatag) - requires v7.x-1.7 or newer.
* Node (Core)
* Path (Core)

Realtime SEO for Drupal module libraries:
* [js-text-analysis](https://github.com/Yoast/js-text-analysis)
* [Jed](https://github.com/SlexAxton/Jed)
